<?php
/**
 * Define customizer Custom classes
 *
 * @package Mystery Themes
 * @subpackage Editorial Pro
 * @since 1.0.0
 */

if ( class_exists( 'WP_Customize_Control' ) ) {
    
    class Editorial_Customize_Category_Control extends WP_Customize_Control {
        /**
         * Render the control's content.
         *
         * @since 3.4.0
         */
        public function render_content() {
            $dropdown = wp_dropdown_categories(
                array(
                    'name'              => '_customize-dropdown-categories-' . $this->id,
                    'echo'              => 0,
                    'show_option_none'  => __( '&mdash; Select Category &mdash;', 'editorial-pro' ),
                    'option_none_value' => '',
                    'selected'          => $this->value(),
                )
            );
 
            // Hackily add in the data link parameter.
            $dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );
 
            printf(
                '<label class="customize-control-select"><span class="customize-control-title">%s</span><span class="description customize-control-description">%s</span> %s </label>',
                $this->label,
                $this->description,
                $dropdown
            );
        }
    }

    /**
     * Radio image customize control.
     *
     * @since  1.0.0
     * @access public
     */
    class Editorial_Customize_Control_Radio_Image extends WP_Customize_Control {
        /**
         * The type of customize control being rendered.
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $type = 'radio-image';

        /**
         * Loads the jQuery UI Button script and custom scripts/styles.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        /*public function enqueue() {
            wp_enqueue_script( 'jquery-ui-button' );
        }*/

        /**
         * Add custom JSON parameters to use in the JS template.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        public function to_json() {
            parent::to_json();

            // We need to make sure we have the correct image URL.
            foreach ( $this->choices as $value => $args )
                $this->choices[ $value ]['url'] = esc_url( sprintf( $args['url'], get_template_directory_uri(), get_stylesheet_directory_uri() ) );

            $this->json['choices'] = $this->choices;
            $this->json['link']    = $this->get_link();
            $this->json['value']   = $this->value();
            $this->json['id']      = $this->id;
        }


        /**
         * Underscore JS template to handle the control's output.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */

        public function content_template() { ?>
            <# if ( data.label ) { #>
                <span class="customize-control-title">{{ data.label }}</span>
            <# } #>

            <# if ( data.description ) { #>
                <span class="description customize-control-description">{{{ data.description }}}</span>
            <# } #>

            <div class="buttonset">

                <# for ( key in data.choices ) { #>

                    <input type="radio" value="{{ key }}" name="_customize-{{ data.type }}-{{ data.id }}" id="{{ data.id }}-{{ key }}" {{{ data.link }}} <# if ( key === data.value ) { #> checked="checked" <# } #> /> 

                    <label for="{{ data.id }}-{{ key }}">
                        <span class="screen-reader-text">{{ data.choices[ key ]['label'] }}</span>
                        <img src="{{ data.choices[ key ]['url'] }}" title="{{ data.choices[ key ]['label'] }}" alt="{{ data.choices[ key ]['label'] }}" />
                    </label>
                <# } #>

            </div><!-- .buttonset -->
        <?php }
    }

    /**
     * Customize control for switch option
     */    
    class Editorial_Customize_Switch_Control extends WP_Customize_Control {
        public $type = 'switch';    
        public function render_content() {
    ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
                <div class="description customize-control-description"><?php echo esc_html( $this->description ); ?></div>
                <div class="switch_options">
                    <?php 
                        $show_choices = $this->choices;
                        foreach ( $show_choices as $key => $value ) {
                            echo '<span class="switch_part '.$key.'" data-switch="'.$key.'">'. $value.'</span>';
                        }
                    ?>
                    <input type="hidden" id="enable_switch_option" <?php $this->link(); ?> value="<?php echo $this->value(); ?>" />
                </div>
            </label>
    <?php
        }
    }

    /**
     * Custom class for typography 
     */
    class Editorial_Pro_Typography_Customizer_Control extends WP_Customize_Control {
    
        /**
         * The type of customize control being rendered.
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $type = 'typography';

        /**
         * Array 
         *
         * @since  1.0.0
         * @access public
         * @var    string
         */
        public $l10n = array();

        /**
         * Set up our control.
         *
         * @since  1.0.0
         * @access public
         * @param  object  $manager
         * @param  string  $id
         * @param  array   $args
         * @return void
         */
        public function __construct( $manager, $id, $args = array() ) {

            // Let the parent class do its thing.
            parent::__construct( $manager, $id, $args );

            // Make sure we have labels.
            $this->l10n = wp_parse_args(
                $this->l10n,
                array(
                    'family'      => esc_html__( 'Font Family', 'editorial-pro' ),
                    'size'        => esc_html__( 'Font Size',   'editorial-pro' ),
                    'style'      => esc_html__( 'Font Weight/Style', 'editorial-pro' ),
                    'line_height' => esc_html__( 'Line Height', 'editorial-pro' ),
                    'px_line_height' => esc_html__( 'Line Height', 'editorial-pro' ),
                    'text_decoration' => esc_html__( 'Text Decoration', 'editorial-pro' ),
                    'text_transform' => esc_html__( 'Text Transform', 'editorial-pro' ),
                    'typocolor' => esc_html__( 'Font Color', 'editorial-pro' )
                )
            );
        }

        /**
         * Enqueue scripts/styles.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        public function enqueue() {
            wp_enqueue_script( 'editorial-pro-customizer-script' );
            wp_enqueue_script( 'wp-color-picker' );
            wp_enqueue_style( 'wp-color-picker' );
        }

        /**
         * Add custom parameters to pass to the JS via JSON.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        public function to_json() {
            parent::to_json();

            // Loop through each of the settings and set up the data for it.
            foreach ( $this->settings as $setting_key => $setting_id ) {
                $this->json[ $setting_key ] = array(
                    'link'  => $this->get_link( $setting_key ),
                    'value' => $this->value( $setting_key ),
                    'label' => isset( $this->l10n[ $setting_key ] ) ? $this->l10n[ $setting_key ] : ''
                );

                if ( 'family' === $setting_key )
                    $this->json[ $setting_key ]['choices'] = $this->get_font_families();

                elseif ( 'style' === $setting_key )
                    $this->json[ $setting_key ]['choices'] = $this->get_font_weight_choices();

                elseif ( 'text_transform' === $setting_key )
                    $this->json[ $setting_key ]['choices'] = $this->get_text_transform_choices();

                elseif ( 'text_decoration' === $setting_key )
                    $this->json[ $setting_key ]['choices'] = $this->get_text_decoration_choices();
            }
        }

        /**
         * Underscore JS template to handle the control's output.
         *
         * @since  1.0.0
         * @access public
         * @return void
         */
        public function content_template() {
        ?>

        <# if ( data.label ) { #>
            <span class="customize-control-title">{{ data.label }}</span>
        <# } #>

        <# if ( data.description ) { #>
            <span class="description customize-control-description">{{{ data.description }}}</span>
        <# } #>

        <ul>

        <# if ( data.family && data.family.choices ) { #>

            <li class="typography-font-family">

            <# if ( data.family.label ) { #>
                <span class="customize-control-title">{{ data.family.label }}</span>
            <# } #>

                <select {{{ data.family.link }}} id="{{ data.section }}" class="typography_face">

                <# _.each( data.family.choices, function( label, choice ) { #>
                    <option value="{{ choice }}" <# if ( choice === data.family.value ) { #> selected="selected" <# } #>>{{ label }}</option>
                <# } ) #>

                </select>

            </li>
        <#  } #>

        <# if ( data.style && data.style.choices ) { #>

            <li class="typography-font-style">

            <# if ( data.style.label ) { #>
                <span class="customize-control-title">{{ data.style.label }}</span>
            <# } #>

                <select {{{ data.style.link }}}>

                <# _.each( data.style.choices, function( label, choice ) { #>
                    <option value="{{ choice }}" <# if ( choice === data.style.value ) { #> selected="selected" <# } #>>{{ label }}</option>
                <# } ) #>

                </select>
            </li>
        <#  } #>

        <# if ( data.text_transform && data.text_transform.choices ) { #>

            <li class="typography-text-transform">

            <# if ( data.text_transform.label ) { #>
                <span class="customize-control-title">{{ data.text_transform.label }}</span>
            <# } #>

                <select {{{ data.text_transform.link }}} id="p_typography_text_transform" class="typography_text_transform">

                    <# _.each( data.text_transform.choices, function( label, choice ) { #>
                        <option value="{{ choice }}" <# if ( choice === data.text_transform.value ) { #> selected="selected" <# } #>>{{ label }}</option>
                    <# } ) #>

                </select>
            </li>
        <# } #>

        <# if ( data.text_decoration && data.text_decoration.choices ) { #>

            <li class="typography-text-decoration">

            <# if ( data.text_decoration.label ) { #>
                <span class="customize-control-title">{{ data.text_decoration.label }}</span>
            <# } #>

                <select {{{ data.text_decoration.link }}} id="p_typography_text_decoration" class="typography_text_decoration">

                    <# _.each( data.text_decoration.choices, function( label, choice ) { #>
                        <option value="{{ choice }}" <# if ( choice === data.text_decoration.value ) { #> selected="selected" <# } #>>{{ label }}</option>
                    <# } ) #>

                </select>
            </li>
        <#  } #>

        <# if ( data.size ) { #>

            <li class="typography-font-size">

            <# if ( data.size.label ) { #>
                <span class="customize-control-title">{{ data.size.label }} </span>
            <# } #>

                <span class="slider-value-size"></span>px
                <input type="hidden" {{{ data.size.link }}} value="{{ data.size.value }}" />
                <div class="slider-range-size" value="{{ data.size.value }}" ></div>
                
            </li>
        <#  } #>

        <# if ( data.line_height ) { #>

            <li class="typography-line-height">

            <# if ( data.line_height.label ) { #>
                <span class="customize-control-title">{{ data.line_height.label }}</span>
            <# } #>

                <span class="slider-value-line-height"></span>
                <input type="hidden" {{{ data.line_height.link }}} value="{{ data.line_height.value }}" />
                <div class="slider-range-line-height" value="{{ data.line_height.value }}"></div>
          
            </li>
        <#  } #>

        <# if ( data.px_line_height ) { #>

            <li class="typography-line-height">

            <# if ( data.px_line_height.label ) { #>
                <span class="customize-control-title">{{ data.px_line_height.label }}</span>
            <# } #>

                <span class="slider-value-size"></span>px
                <div class="slider-range-size" {{{ data.px_line_height.link }}} value="{{ data.px_line_height.value }}"  ></div>
          
            </li>
        <#  } #>

        <# if ( data.typocolor ) { #>

            <li class="typography-color">
                <# if ( data.typocolor.label ) { #>
                    <span class="customize-control-title">{{{ data.typocolor.label }}}</span>
                <# } #>

                    <div class="customize-control-content">
                        <input class="color-picker-hex" type="text" maxlength="7" placeholder="<?php esc_attr_e( 'Hex Value', 'editorial-pro' ); ?>" {{{ data.typocolor.link }}} value="{{ data.typocolor.value }}"  />
                    </div>
            </li>
        <#  } #>

        </ul>
        <?php }

        /**
         * Returns the available fonts.  Fonts should have available weights, styles, and subsets.
         *
         * @todo Integrate with Google fonts.
         *
         * @since  1.0.0
         * @access public
         * @return array
         */
        public function get_fonts() { return array(); }

        /**
         * Returns the available font families.
         *
         * @todo Pull families from `get_fonts()`.
         *
         * @since  1.0.0
         * @access public
         * @return array
         */
        function get_font_families() {
            /* Google font listing in to database */
            $font_encoded = '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';
            $font_decoded = base64_decode( $font_encoded );
            $font_array = unserialize( $font_decoded );

            $editorial_pro_google_font = get_option( 'editorial_pro_google_font', '' );
            $font_update_count = get_option( 'editorial_pro_font_update_count', '' );
            if( empty( $editorial_pro_google_font ) ) {
                update_option( 'editorial_pro_google_font', $font_array );
                $editorial_pro_google_font = get_option( 'editorial_pro_google_font', '' );
            } elseif( !empty( $editorial_pro_google_font ) && empty( $font_update_count ) ) {
                update_option( 'editorial_pro_google_font', $font_array );
                $editorial_pro_google_font = get_option( 'editorial_pro_google_font', '' );
                $font_update_count = 'updated' ;
                update_option( 'editorial_pro_font_update_count', $font_update_count );
            }

            foreach ( $editorial_pro_google_font as $key => $value ) {
                $mt_fonts[$value['family']] =  $value['family'] ;
            }

            return $mt_fonts;
        }

        /**
         * Returns the available font weights.
         *
         * @since  1.0.0
         * @access public
         * @return array
         */
        public function get_font_weight_choices() {
            if( $this->settings['family']->id ){
                $editorial_pro_font_list = get_option( 'editorial_pro_google_font', '' );

                $font_family_id = $this->settings['family']->id;
                $default_font_family = $this->settings['family']->default;
                $get_font_family = get_theme_mod( $font_family_id, $default_font_family );

                $font_array = editorial_pro_search_key( $editorial_pro_font_list, 'family', $get_font_family );

                $variants_array = $font_array['0']['variants'] ;

                if( is_array( $variants_array ) ){
                    $options_array = array();
                    foreach ( $variants_array  as $key => $variants ) {
                        $options_array[$key] = $variants;
                    }
                    return $options_array;
                }else{
                    return array(
                        '100' => esc_html__( 'Thin', 'editorial-pro' ),
                        '200' => esc_html__( 'Extra Light', 'editorial-pro' ),
                        '200italic' => esc_html__( 'Extra Light Italic', 'editorial-pro' ),
                        '300' => esc_html__( 'Light', 'editorial-pro' ),
                        '400' => esc_html__( 'Normal', 'editorial-pro' ),
                        '500' => esc_html__( 'Medium', 'editorial-pro' ),
                        '600' => esc_html__( 'Semi Bold', 'editorial-pro' ),
                        '700' => esc_html__( 'Bold', 'editorial-pro' ),
                        '900' => esc_html__( 'Ultra Bold', 'editorial-pro' ),
                    );
                }
            } else {
                return array(
                    '100' => esc_html__( 'Thin', 'editorial-pro' ),
                    '200' => esc_html__( 'Extra Light', 'editorial-pro' ),
                    '200italic' => esc_html__( 'Extra Light Italic', 'editorial-pro' ),
                    '300' => esc_html__( 'Light', 'editorial-pro' ),
                    '400' => esc_html__( 'Normal', 'editorial-pro' ),
                    '500' => esc_html__( 'Medium', 'editorial-pro' ),
                    '600' => esc_html__( 'Semi Bold', 'editorial-pro' ),
                    '700' => esc_html__( 'Bold', 'editorial-pro' ),
                    '900' => esc_html__( 'Ultra Bold', 'editorial-pro' ),
                );
            }
        }

        /**
         * Returns the available font text decoration.
         *
         * @since  1.0.0
         * @access public
         * @return array
         */
        public function get_text_decoration_choices() {
            return array(
                'none'  => esc_html__( 'None', 'editorial-pro' ),
                'underline'  => esc_html__( 'Underline', 'editorial-pro' ),
                'line-through' => esc_html__( 'Line-through', 'editorial-pro' ),
                'overline' => esc_html__( 'Overline', 'editorial-pro' )
            );
        }

        /**
         * Returns the available font text transform.
         *
         * @since  1.0.0
         * @access public
         * @return array
         */
        public function get_text_transform_choices() {
            return array(
                'none'  => esc_html__( 'None', 'editorial-pro' ),
                'uppercase'  => esc_html__( 'Uppercase', 'editorial-pro' ),
                'lowercase' => esc_html__( 'Lowercase', 'editorial-pro' ),
                'capitalize' => esc_html__( 'Capitalize', 'editorial-pro' )
            );
        }
    }

}